/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.command;

import com.mojang.authlib.properties.Property;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;
import org.samo_lego.fabrictailor.compatibility.TaterzenSkins;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.samo_lego.fabrictailor.util.TextTranslations;

public class SkinCommand {
    private static final class_5250 SKIN_SET_ERROR = TextTranslations.create("command.fabrictailor.skin.set.404", new Object[0]).method_27692(class_124.field_1061);
    private static final boolean TATERZENS_LOADED = FabricLoader.getInstance().isModLoaded("taterzens");
    private static final class_5250 SET_SKIN_ATTEMPT = TextTranslations.create("command.fabrictailor.skin.set.attempt", new Object[0]);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"skin").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"URL").then(class_2170.method_9247((String)"classic").then(class_2170.method_9244((String)"skin URL", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinUrl((CommandContext<class_2168>)context, false))))).then(class_2170.method_9247((String)"slim").then(class_2170.method_9244((String)"skin URL", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinUrl((CommandContext<class_2168>)context, true))))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404.url", new Object[0]).method_27692(class_124.field_1061));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"upload").then(class_2170.method_9247((String)"classic").then(class_2170.method_9244((String)"skin file path", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinFile((CommandContext<class_2168>)context, false))))).then(class_2170.method_9247((String)"slim").then(class_2170.method_9244((String)"skin file path", (ArgumentType)class_2196.method_9340()).executes(context -> SkinCommand.setSkinFile((CommandContext<class_2168>)context, true))))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404.path", new Object[0]).method_27692(class_124.field_1061));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"custom").requires(ctx -> !FabricTailor.config.customSkinServer.isEmpty())).then(class_2170.method_9247((String)"classic").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SkinCommand.setSkinCustom((CommandContext<class_2168>)context, false))))).then(class_2170.method_9247((String)"slim").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> SkinCommand.setSkinCustom((CommandContext<class_2168>)context, true))))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404.playername", new Object[0]).method_27692(class_124.field_1061));
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").then(class_2170.method_9244((String)"playername", (ArgumentType)StringArgumentType.greedyString()).executes(SkinCommand::setSkinPlayer))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404.playername", new Object[0]).method_27692(class_124.field_1061));
            return 1;
        }))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9213((class_2561)TextTranslations.create("command.fabrictailor.skin.set.404", new Object[0]).method_27692(class_124.field_1061));
            return 1;
        }))).then(class_2170.method_9247((String)"clear").executes(context -> SkinCommand.clearSkin(((class_2168)context.getSource()).method_9207()) ? 1 : 0)));
    }

    private static int setSkinCustom(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String playername = StringArgumentType.getString(context, (String)"name");
        String skinUrl = FabricTailor.config.customSkinServer.replace("{player}", playername);
        SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByUrl(skinUrl, useSlim));
        return 1;
    }

    private static int setSkinUrl(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String skinUrl = class_2196.method_9339(context, (String)"skin URL").getString();
        SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByUrl(skinUrl, useSlim));
        return 1;
    }

    private static int setSkinFile(CommandContext<class_2168> context, boolean useSlim) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String skinFilePath = class_2196.method_9339(context, (String)"skin file path").getString();
        MinecraftServer server = player.method_5682();
        if (server != null && server.method_3816()) {
            player.method_7353((class_2561)TextTranslations.create("hint.fabrictailor.server_skin_path", new Object[0]).method_27692(class_124.field_1065), false);
        }
        SkinCommand.setSkin(player, () -> SkinFetcher.setSkinFromFile(skinFilePath, useSlim));
        player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.please_wait", new Object[0]).method_27692(class_124.field_1065), false);
        return 1;
    }

    private static int setSkinPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String playername = StringArgumentType.getString(context, (String)"playername");
        SkinCommand.setSkin(player, () -> SkinFetcher.fetchSkinByName(playername));
        return 1;
    }

    private static void setSkin(class_3222 player, Supplier<Property> skinProvider) {
        long lastChange = ((TailoredPlayer)player).getLastSkinChange();
        long now = System.currentTimeMillis();
        if (now - lastChange > FabricTailor.config.skinChangeTimer * 1000L || lastChange == 0L) {
            player.method_7353((class_2561)SET_SKIN_ATTEMPT.method_27692(class_124.field_1075), false);
            FabricTailor.THREADPOOL.submit(() -> {
                Property skinData = (Property)skinProvider.get();
                if (skinData == null) {
                    player.method_7353((class_2561)SKIN_SET_ERROR, false);
                } else {
                    if (!TATERZENS_LOADED || !TaterzenSkins.setTaterzenSkin(player, skinData)) {
                        ((TailoredPlayer)player).setSkin(skinData, true);
                    }
                    player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.set.success", new Object[0]).method_27692(class_124.field_1060), false);
                }
            });
        } else {
            class_5250 timeLeft = class_2561.method_43470((String)String.valueOf((FabricTailor.config.skinChangeTimer * 1000L - now + lastChange) / 1000L)).method_27692(class_124.field_1076);
            player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.timer.please_wait", timeLeft).method_27692(class_124.field_1061), false);
        }
    }

    public static boolean clearSkin(class_3222 player) {
        long lastChange = ((TailoredPlayer)player).getLastSkinChange();
        long now = System.currentTimeMillis();
        if (now - lastChange > FabricTailor.config.skinChangeTimer * 1000L || lastChange == 0L) {
            ((TailoredPlayer)player).clearSkin();
            player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.clear.success", new Object[0]).method_27692(class_124.field_1060), false);
            return true;
        }
        class_5250 timeLeft = class_2561.method_43470((String)String.valueOf((FabricTailor.config.skinChangeTimer * 1000L - now + lastChange) / 1000L)).method_27692(class_124.field_1076);
        player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.timer.please_wait", timeLeft).method_27692(class_124.field_1061), false);
        return false;
    }
}

